<?php
/**
 * PayFort API Configuration
 * 
 * Configure your PayFort credentials here.
 * Get your API key from your PayFort dashboard: Settings => API Credentials
 * 
 * IMPORTANT: Never commit this file with real credentials to version control!
 * Use environment variables or a secure configuration system in production.
 */

// PayFort API Configuration
// TODO: Replace with your actual PayFort API credentials
$PAYFORT_CONFIG = [
    'api_key' => 'jGZvaWEYvAnYIBwMX17EmkrIytEeWCwrUG/q5YUpx7fL5A35LsIKBjX96JG8GbqRDwAP4w8V0uQcD1p3mZ+WlA==', // Your PayFort API Key
    'cashin_url' => 'https://cashin.safepayments.cloud',
    'cashout_url' => 'https://cashout.safepayments.cloud',
    'webhook_url' => 'https://portal.cpfregular.is/webhook.php', // Your webhook URL
    'environment' => 'production', // 'sandbox' or 'production'
    'timeout' => 30, // Request timeout in seconds
    'retry_attempts' => 3, // Number of retry attempts for failed requests
];

// Environment-specific configurations
if ($PAYFORT_CONFIG['environment'] === 'sandbox') {
    // Sandbox URLs (if available)
    $PAYFORT_CONFIG['cashin_url'] = 'https://sandbox-cashin.safepayments.cloud';
    $PAYFORT_CONFIG['cashout_url'] = 'https://sandbox-cashout.safepayments.cloud';
}

// Helper function to get PayFort configuration
function getPayFortConfig() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG;
}

// Helper function to check if credentials are configured
function isPayFortConfigured() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG['api_key'] !== 'YOUR_PAYFORT_API_KEY_HERE' && !empty($PAYFORT_CONFIG['api_key']);
}

// Helper function to get API key
function getPayFortApiKey() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG['api_key'];
}

// Helper function to get Cash-In URL
function getPayFortCashInUrl() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG['cashin_url'];
}

// Helper function to get Cash-Out URL
function getPayFortCashOutUrl() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG['cashout_url'];
}

// Helper function to get webhook URL
function getPayFortWebhookUrl() {
    global $PAYFORT_CONFIG;
    return $PAYFORT_CONFIG['webhook_url'];
}

// Helper function to create Bearer Auth header
function createPayFortAuthHeader() {
    return 'Bearer ' . getPayFortApiKey();
}

// Validation function
function validatePayFortConfig() {
    if (!isPayFortConfigured()) {
        throw new Exception('PayFort API Key não configurada. Configure as credenciais no arquivo payfort-config.php');
    }
    
    $config = getPayFortConfig();
    
    if (empty($config['cashin_url']) || empty($config['cashout_url'])) {
        throw new Exception('URLs do PayFort não configuradas corretamente');
    }
    
    return true;
}

// Log configuration status (for debugging)
if (!isPayFortConfigured()) {
    error_log('PayFort: API Key não configurada. Configure as credenciais no arquivo payfort-config.php');
} else {
    error_log('PayFort: Configuração carregada com sucesso');
}
?>
